#include <bits/stdc++.h>
using namespace std;
using int64 = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int N;
    if (!(cin >> N)) return 0;
    vector<pair<int64,int64>> pts(N);
    for (int i = 0; i < N; ++i) cin >> pts[i].first >> pts[i].second;

    unordered_map<int64, pair<int64,int64>> byX;
    unordered_map<int64, pair<int64,int64>> byY; 
    unordered_map<int64, int64> diag1;
    unordered_map<int64, int64> diag2;

    byX.reserve(N*2);
    byY.reserve(N*2);
    diag1.reserve(N*2);
    diag2.reserve(N*2);

    for (auto &p : pts) {
        int64 x = p.first, y = p.second;
        if ((y & 1LL) == 0) byX[x].first++; else byX[x].second++;
        if ((x & 1LL) == 0) byY[y].first++; else byY[y].second++;
        diag1[x - y]++;
        diag2[x + y]++;
    }

    auto choose2 = [](int64 m)->int64 {
        return m * (m - 1) / 2;
    };

    int64 ans = 0;

    for (auto &kv : byX) {
        int64 even = kv.second.first;
        int64 odd = kv.second.second;
        ans += choose2(even);
        ans += choose2(odd);
    }

    for (auto &kv : byY) {
        int64 even = kv.second.first;
        int64 odd = kv.second.second;
        ans += choose2(even);
        ans += choose2(odd);
    }

    for (auto &kv : diag1) {
        int64 m = kv.second;
        if (m >= 2) ans += 2 * choose2(m);
    }

    for (auto &kv : diag2) {
        int64 m = kv.second;
        if (m >= 2) ans += 2 * choose2(m);
    }

    cout << ans << '\n';
    return 0;
}